module.exports = {
  browser: {
    headless: true,
    args: [
      '--no-sandbox',
      '--disable-setuid-sandbox',
      '--disable-dev-shm-usage',
      '--disable-gpu',
      '--disable-web-security',
      '--disable-features=IsolateOrigins,site-per-process',
      '--disable-blink-features=AutomationControlled',
      '--window-size=1280,720',
      '--disable-images',
      '--disable-javascript-harmony',
      '--disable-background-timer-throttling',
      '--disable-renderer-backgrounding',
      '--disable-features=TranslateUI',
      '--disable-ipc-flooding-protection'
    ]
  },
  timeouts: {
    navigation: 15000,    // Optimized: faster but safe
    implicit: 6000,       // Optimized: balanced
    verification: 8000    // Optimized: enough for slow connections
  },
  delays: {
    typing: 25,           // Optimized: natural typing speed
    betweenActions: 400,  // Optimized: faster but stable
    afterLogin: 1500,     // Optimized: reduced but safe
    modalWait: 2000       // Optimized: reduced but reliable
  },
  bulk: {
    batchSize: 4,         // Optimized: 4 parallel (balanced)
    batchDelay: 3000      // Optimized: 3 seconds between batches
  },
  totp: {
    apiUrl: 'https://2fa.live/tok',
    useLocalFallback: true  // Use local generation if API slow
  },
  output: {
    format: 'csv',
    filename: 'output/results.csv'
  },
  debug: {
    screenshots: false,
    saveLogs: false
  }
};
