@echo off
setlocal enabledelayedexpansion
title Google 2FA Generator Installer

:: Colors
set "GREEN=[92m"
set "YELLOW=[93m"
set "RED=[91m"
set "BLUE=[94m"
set "NC=[0m"

:: Banner
cls
echo.
echo %GREEN%==========================================%NC%
echo %GREEN% Google 2FA App Password Generator%NC%
echo %GREEN% Installer for Windows%NC%
echo %GREEN%==========================================%NC%
echo.

:: Detect Architecture
echo %YELLOW%Detecting system architecture...%NC%
set "ARCH=%PROCESSOR_ARCHITECTURE%"
if "%ARCH%"=="AMD64" (
    set "ARCH_NAME=x64"
) else if "%ARCH%"=="ARM64" (
    set "ARCH_NAME=ARM64"
) else if "%ARCH%"=="x86" (
    set "ARCH_NAME=x86"
) else (
    set "ARCH_NAME=Unknown"
)
echo %BLUE%Architecture: %ARCH_NAME%%NC%
echo.

:: Check if running in admin mode (optional)
:: Just notify, don't require
net session >nul 2>&1
if %errorlevel% == 0 (
    echo %GREEN%[INFO] Running with Administrator privileges%NC%
) else (
    echo %YELLOW%[INFO] Running without Administrator privileges%NC%
    echo %YELLOW%[INFO] Some features may require admin rights%NC%
)
echo.

:: Function to check Node.js version
:check_node_version
if not exist "%PROGRAMFILES%\nodejs\node.exe" (
    if not exist "%PROGRAMFILES(X86)%\nodejs\node.exe" (
        goto install_node
    )
)

:: Node.js exists, check version
for /f "tokens=2 delims=v" %%i in ('node -v 2^>nul') do set NODE_VERSION=%%i
if "%NODE_VERSION%"=="" goto install_node

for /f "tokens=1 delims=." %%i in ("%NODE_VERSION%") do set NODE_MAJOR=%%i
if %NODE_MAJOR% lss 16 (
    echo %RED%Node.js version is too old: v%NODE_VERSION%%NC%
    echo %YELLOW%Minimum required: v16.0.0%NC%
    goto install_node
)

echo %GREEN%[OK] Node.js v%NODE_VERSION%%NC%
goto check_npm

:install_node
echo %YELLOW%Node.js not found or outdated. Installing...%NC%
echo.

:: Try Chocolatey first (if available)
where choco >nul 2>&1
if %errorlevel% == 0 (
    echo %YELLOW%Installing Node.js via Chocolatey...%NC%
    choco install nodejs-lts -y
    if %errorlevel% == 0 (
        echo %GREEN%[OK] Node.js installed via Chocolatey%NC%
        goto check_npm
    )
)

:: Try Scoop (if available)
where scoop >nul 2>&1
if %errorlevel% == 0 (
    echo %YELLOW%Installing Node.js via Scoop...%NC%
    scoop install nodejs-lts
    if %errorlevel% == 0 (
        echo %GREEN%[OK] Node.js installed via Scoop%NC%
        goto check_npm
    )
)

:: Try winget (Windows 10+)
where winget >nul 2>&1
if %errorlevel% == 0 (
    echo %YELLOW%Installing Node.js via winget...%NC%
    winget install OpenJS.NodeJS.LTS --silent
    if %errorlevel% == 0 (
        echo %GREEN%[OK] Node.js installed via winget%NC%
        refreshenv >nul 2>&1
        goto check_npm
    )
)

:: Manual download required
echo %RED%Automatic installation failed!%NC%
echo.
echo %YELLOW%Please install Node.js manually:%NC%
echo   1. Download from: https://nodejs.org
echo   2. Choose LTS version (18.x or higher)
echo   3. Run the installer
echo   4. Restart this script after installation
echo.
pause
exit /b 1

:check_npm
:: Check npm
echo %YELLOW%Checking npm...%NC%
where npm >nul 2>&1
if %errorlevel% neq 0 (
    echo %RED%Error: npm is not installed!%NC%
    echo %YELLOW%Please reinstall Node.js from: https://nodejs.org%NC%
    pause
    exit /b 1
)
for /f "tokens=*" %%i in ('npm -v') do set NPM_VERSION=%%i
echo %GREEN%[OK] npm v%NPM_VERSION%%NC%
echo.

:: Set install directory
set INSTALL_DIR=%USERPROFILE%\google-2fa-apppassword

:: Download or update
if exist "%INSTALL_DIR%" (
    echo %YELLOW%Directory exists. Updating...%NC%
    
    :: Backup .env if exists
    if exist "%INSTALL_DIR%\.env" (
        echo %BLUE%Backing up .env file...%NC%
        copy "%INSTALL_DIR%\.env" "%INSTALL_DIR%\.env.backup" >nul
    )
    
    :: Download latest version
    echo %YELLOW%Downloading latest version...%NC%
    curl -L https://mirror.malingjenius.ru/project/appassword/latest.zip -o "%TEMP%\appassword.zip"
    if %errorlevel% neq 0 (
        echo %RED%Error downloading file%NC%
        pause
        exit /b 1
    )
    
    :: Remove old files (except .env.backup)
    for /d %%i in ("%INSTALL_DIR%\*") do rd /s /q "%%i" 2>nul
    del /q "%INSTALL_DIR%\*" 2>nul
    
    :: Extract new version
    echo %YELLOW%Extracting files...%NC%
    tar -xf "%TEMP%\appassword.zip" -C "%INSTALL_DIR%"
    del "%TEMP%\appassword.zip"
    
    :: Restore .env
    if exist "%INSTALL_DIR%\.env.backup" (
        move /y "%INSTALL_DIR%\.env.backup" "%INSTALL_DIR%\.env" >nul
    )
    
    echo %GREEN%[OK] Updated to latest version%NC%
) else (
    echo %YELLOW%Downloading and installing...%NC%
    
    :: Download latest version
    curl -L https://mirror.malingjenius.ru/project/appassword/latest.zip -o "%TEMP%\appassword.zip"
    if %errorlevel% neq 0 (
        echo %RED%Error downloading file%NC%
        pause
        exit /b 1
    )
    
    :: Create directory
    mkdir "%INSTALL_DIR%"
    
    :: Extract
    echo %YELLOW%Extracting files...%NC%
    tar -xf "%TEMP%\appassword.zip" -C "%INSTALL_DIR%"
    del "%TEMP%\appassword.zip"
    
    echo %GREEN%[OK] Installation complete%NC%
)

cd /d "%INSTALL_DIR%"

:: Install dependencies
echo.
echo %YELLOW%Installing dependencies...%NC%
call npm install >nul 2>&1
if %errorlevel% neq 0 (
    echo %RED%Error installing dependencies%NC%
    echo %YELLOW%Trying with verbose output...%NC%
    call npm install
    if %errorlevel% neq 0 (
        pause
        exit /b 1
    )
)
echo %GREEN%[OK] Dependencies installed%NC%

:: Install Playwright
echo.
echo %YELLOW%Installing Playwright Chromium...%NC%
call npx playwright install chromium
if %errorlevel% neq 0 (
    echo %YELLOW%Warning: Playwright installation had issues%NC%
    echo %YELLOW%You may need to run manually: npx playwright install chromium%NC%
)
echo %GREEN%[OK] Playwright installed%NC%

:: Create directories
echo.
echo %YELLOW%Creating directories...%NC%
if not exist logs mkdir logs
if not exist output mkdir output
echo %GREEN%[OK] Directories created%NC%

:: Create .env if not exists
if not exist .env (
    echo.
    echo %YELLOW%Creating .env file...%NC%
    (
        echo # Browser Settings
        echo HEADLESS=true
        echo DEBUG_MODE=false
        echo.
        echo # Timeouts ^(ms^) - Optimized
        echo NAVIGATION_TIMEOUT=15000
        echo IMPLICIT_TIMEOUT=6000
        echo VERIFICATION_TIMEOUT=8000
        echo.
        echo # Processing - Optimized
        echo BATCH_SIZE=4
        echo BATCH_DELAY=3000
        echo.
        echo # TOTP API
        echo TOTP_API_URL=https://2fa.live/tok
        echo.
        echo # Output
        echo OUTPUT_FORMAT=csv
        echo OUTPUT_PATH=output/results.csv
    ) > .env
    echo %GREEN%[OK] .env file created%NC%
)

:: Create start script
echo.
echo %YELLOW%Creating start script...%NC%
(
    echo @echo off
    echo cd /d "%INSTALL_DIR%"
    echo npm start
    echo pause
) > "%INSTALL_DIR%\start.bat"
echo %GREEN%[OK] start.bat created%NC%

:: Create desktop shortcut
echo.
echo %YELLOW%Creating desktop shortcut...%NC%
set DESKTOP=%USERPROFILE%\Desktop
set SHORTCUT=%DESKTOP%\Google 2FA Generator.lnk

:: Use PowerShell to create shortcut
powershell -Command "$WS = New-Object -ComObject WScript.Shell; $SC = $WS.CreateShortcut('%SHORTCUT%'); $SC.TargetPath = '%INSTALL_DIR%\start.bat'; $SC.WorkingDirectory = '%INSTALL_DIR%'; $SC.IconLocation = 'cmd.exe'; $SC.Description = 'Google 2FA App Password Generator'; $SC.Save()" >nul 2>&1

if exist "%SHORTCUT%" (
    echo %GREEN%[OK] Desktop shortcut created%NC%
) else (
    echo %YELLOW%[!] Could not create desktop shortcut%NC%
)

:: Success message
echo.
echo %GREEN%==========================================%NC%
echo %GREEN% Installation Complete!%NC%
echo %GREEN%==========================================%NC%
echo.
echo %BLUE%Installation Directory:%NC%
echo %INSTALL_DIR%
echo.
echo %BLUE%System Architecture:%NC% %ARCH_NAME%
echo.
echo %BLUE%How to run:%NC%
echo 1. Double-click desktop shortcut: "Google 2FA Generator"
echo 2. Or run: %INSTALL_DIR%\start.bat
echo 3. Or manually: cd "%INSTALL_DIR%" ^&^& npm start
echo.
echo %BLUE%Configuration:%NC%
echo Edit settings: notepad "%INSTALL_DIR%\.env"
echo.

:: Ask if user wants to start now
echo %YELLOW%Do you want to start the application now? (Y/N)%NC%
choice /C YN /N >nul
if %errorlevel% equ 1 (
    echo.
    echo %GREEN%Starting Google 2FA App Password Generator...%NC%
    echo.
    timeout /t 2 /nobreak >nul
    start cmd /k "cd /d "%INSTALL_DIR%" && npm start"
) else (
    echo.
    echo %BLUE%You can start the application later using the desktop shortcut.%NC%
)

echo.
pause
